function DropDownTest_InitializeDropDown(self, level)
  -- Create a table to use for button information
  local info = UIDropDownMenu_CreateInfo()

  info.text = "Title Button"
  info.isTitle = true
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Disabled Button"
  info.disabled = true
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Colored Text"
  info.colorCode = "|cFF33FF22"
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Not Clickable"
  info.notClickable = true
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Not Checkable"
  info.notCheckable = true
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Button with Tooltip"
  info.tooltipTitle = "Tooltip title"
  info.tooltipText = "Contents of the tooltip"
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Centered Text"
  info.justifyH = "CENTER"
  info.notCheckable = true
  UIDropDownMenu_AddButton(info)

  info = UIDropDownMenu_CreateInfo()
  info.text = "Text with custom font"
  info.fontObject = SystemFont_Small
  UIDropDownMenu_AddButton(info)

info = UIDropDownMenu_CreateInfo()
info.text = "Function Button"
function info.func(button, arg1, arg2)
  print("CALL: Arg1: " .. tostring(arg1) .. " Arg2: " .. tostring(arg2))
end
info.arg1 = "Foo"
info.arg2 = "Bar"
UIDropDownMenu_AddButton(info)

info = UIDropDownMenu_CreateInfo()
info.text = "Toggleable setting"
info.checked = SOME_SETTING
function info.func(button, arg1, arg2)
  SOME_SETTING = not SOME_SETTING
  print("SOME_SETTING is " .. tostring(SOME_SETTING)
end
UIDropDownMenu_AddButton(info)

info = UIDropDownMenu_CreateInfo()
info.text = "Button Text Color"
info.hasColorSwatch = true
local oldr, oldg, oldb, olda = DropDownTest_ButtonText:GetTextColor()
info.r = oldr
info.g = oldg
info.b = oldb
function info.swatchFunc()
  local r, g, b = ColorPickerFrame:GetColorRGB()
  DropDownTest_ButtonText:SetTextColor(r, g, b)
end
function info.cancelFunc(prev)
  DropDownTest_ButtonText:SetTextColor(prev.r, prev.g, prev.g)
end
UIDropDownMenu_AddButton(info)

end

function DropDownTest_DropDownOnLoad(self)
    UIDropDownMenu_Initialize(self, DropDownTest_InitializeDropDown)
end

function DropDownTest_ButtonOnClick(self, button, down)
    local name = self:GetName()
    ToggleDropDownMenu(1, nil, DropDownTest_DropDown, name, 0, 0)
end

