CreateFrame("Frame", "TestHeader", UIParent, "SecureStateHeaderTemplate")
TestHeader:SetPoint("CENTER")

local nextButton = 1
function CreateTestButton()
  -- Create the button
  local button = CreateFrame(
    "CheckButton",
    "TestButton"..nextButton,
    TestHeader,
    "ActionBarButtonTemplate"
  )
  button:SetAttribute("useparent-statebutton", true)
  
  -- Add the button to the header 
  TestHeader:SetAttribute("addchild", button)
  
  -- Attach buttons beyond the first to the previous one
  if nextButton > 1 then
    button:SetPoint("LEFT", _G["TestButton"..(nextButton - 1)], "RIGHT")
  end
  
  -- Move the first button to the left to keep all the buttons centered
  local offsetX = - (nextButton - 1) * button:GetWidth() / 2
  TestButton1:SetPoint("CENTER", TestHeader, "CENTER", offsetX, 0)
  
  nextButton = nextButton + 1
  return button
end
