MacroSequenceSequences = {
--[==[
Each entry in this table defines a single macro sequence akin to the
/castsequence command. Take the following macro, for example:

  /castsequence reset=alt/10 Immolate, Corruption, Curse of Agony

This can be represented as follows:

  WarlockStarter = {
    reset = {
      alt = true,
      seconds = 10
    },
    
    "/cast Immolate",
    "/cast Corruption",
    "/cast Curse of Agony"
  },

The easiest way to trigger a sequence is to /click it in a macro. The button's
name is the same as the sequence (so be sure to choose a unique name). For the
example above, the /click macro would be:

  /click WarlockStarter

Alternatively, you can set a key binding to the button with a one-time command
like:

  /run SetBindingClick("CTRL-5", "WarlockStarter") SaveBindings(GetCurrentBindingSet())

The first time you click the button, it will run the first command in the
sequence. Each subsequent click will advance to the next one until it reaches
the end, in which case it will reset to the beginning. Like the /castsequence
command, the sequence will also reset if you die.
  
The reset entry is optional, but every sequence must have a list of macros. Each
item in the list can be an entire macro of unlimited size (meaning this addon
can also be used for extended macros). Use Lua's long string syntax to make
editing easier (be sure to align it with the left column or they will not be
seen as slash commands):

  MageSequence = {
    [[
/say Hello
/wave
    ]],
    
    [[
/use Talisman of Ephemeral Power
/cast Arcane Power
/cast Presence of Mind
/cast Pyroblast
    ]]
  }

Alternatively, you can use one-line strings with \n to separate the lines.

The reset entry can contain any combination of the following items:

alt - boolean
  Reset the sequence when you run it while holding alt.
ctrl - boolean
  Reset the sequence when you run it while holding ctrl.
shift - boolean
  Reset the sequence when you run it while holding shift.
combat - boolean
  Reset the sequence when you enter or leave combat.
seconds - number
  If specified, the sequence will reset after the given amount of time. If the
  sequence is advanced before the time is up, the timer will be restarted. A
  time of 0 is the same as not specifying a time.

]==]

  -- Template
  --[=[
  
  ButtonName = {
    --[[
    
    reset = {
      -- alt = true,
      -- ctrl = true,
      -- shift = true,
      -- combat = true,
      -- seconds = 0
    },
    
    --]]
  
    -- "Macro 1",
    --[[
Macro 2
    ]],
    -- ...
    }
  },
  
  ]=]
    
}