TargetTextBuffs = {}

local buffFrames = {}
local debuffFrames = {}

local BUFFS_PER_ROW = 8
local BUFF_SPACING = 2
local BUFF_TYPE_OFFSET_Y = -7

function TargetTextBuffs:OnLoad(frame)
  frame:RegisterEvent("PLAYER_TARGET_CHANGED")
  frame:RegisterEvent("UNIT_AURA")
end

function TargetTextBuffs:OnEvent(event, unit)
  if unit == "target" or event == "PLAYER_TARGET_CHANGED" then
    local anchorBuff = self:UpdateBuffs()
    local anchorDebuff = self:UpdateDebuffs()
    
    if UnitIsFriend("player", "target") then
      -- Buffs on top
      self:UpdateAnchors(buffFrames[1], debuffFrames[1], anchorBuff)
    else
      -- Debuffs on top
      self:UpdateAnchors(debuffFrames[1], buffFrames[1], anchorDebuff)
    end
  end
end

function TargetTextBuffs:UpdateAnchors(firstFrame, secondFrame, anchorTo)
  if firstFrame and firstFrame:IsShown() then
    firstFrame:SetPoint("TOPLEFT", TargetTextBuffsFrame)
    if secondFrame and secondFrame:IsShown() then
      secondFrame:SetPoint("TOPLEFT", anchorTo, "BOTTOMLEFT", 0, BUFF_TYPE_OFFSET_Y)
    end
  elseif secondFrame and secondFrame:IsShown() then
    secondFrame:SetPoint("TOPLEFT", TargetTextBuffsFrame)
  end
end

function TargetTextBuffs:UpdateBuffs()
  return self:UpdateBuffsBase(
    function(index)
      -- protects against possible future additions to the returns
      local icon, count, duration, timeLeft = select(3, UnitBuff("target", index))
      return icon, count, duration, timeLeft
    end,
    buffFrames, 
    "CreateBuff"
  )
end

function TargetTextBuffs:UpdateDebuffs()
  return self:UpdateBuffsBase(
    function(index)
      local icon, count, debuffType, duration, timeLeft = select(3, UnitDebuff("target", index))
      return icon, count, duration, timeLeft, debuffType
    end,
    debuffFrames,
    "CreateDebuff"
  )
end

function TargetTextBuffs:UpdateBuffsBase(BuffFunc, frames, method)
  local index = 1
  local icon, count, duration, timeLeft, debuffType = BuffFunc(index)
  local anchorBuff
  
  while icon do
    local buff = frames[index] or self[method](self, index)
    buff:Show()
    
    if index % BUFFS_PER_ROW == 1 then
      anchorBuff = buff
    end
    
    buff.icon:SetTexture(icon)

    if count > 1 then
      buff.count:SetText(count)
      buff.count:Show()
    else
      buff.count:Hide()
    end
    
    if duration and duration > 0 then
      local startTime = GetTime() - (duration - timeLeft)
      buff.cooldown:SetCooldown(startTime, duration)
      buff.cooldown:Show()
    else
      buff.cooldown:Hide()
    end
    
    if buff.border then
      local color
      if debuffType then
        color = DebuffTypeColor[debuffType]
      else
        color = DebuffTypeColor["none"]
      end
      buff.border:SetVertexColor(color.r, color.g, color.b)
    end
    
    index = index + 1
    icon, count, duration, timeLeft, debuffType = BuffFunc(index)
  end
  
  for i = index, #frames do
    frames[i]:Hide()
  end
  
  return anchorBuff
end

function TargetTextBuffs:CreateBuff(index)
  return self:CreateBuffBase(
    index,
    buffFrames,
    "TargetTextBuff"..index,
    "TargetBuffButtonTemplate"
  )
end

function TargetTextBuffs:CreateDebuff(index)
  return self:CreateBuffBase(
    index,
    debuffFrames,
    "TargetTextDebuff"..index,
    "TargetTextBuffsDebuffTemplate"
  )
end

function TargetTextBuffs:CreateBuffBase(index, frames, name, template)
  local frame = CreateFrame("Button", name, TargetTextBuffsFrame, template)
  
  frame.icon = _G[name.."Icon"]
  frame.cooldown = _G[name.."Cooldown"]
  frame.count = _G[name.."Count"]
  frame.border = _G[name.."Border"]
  frame.id = index
  
  local relativeTo, relativePoint, offsetX, offsetY
  if index == 1 then
    -- Use default (empty) values
  elseif index % BUFFS_PER_ROW == 1 then
    relativeTo = frames[index - BUFFS_PER_ROW]
    relativePoint = "BOTTOMLEFT"
    offsetX = 0
    offsetY = - BUFF_SPACING
  else
    relativeTo = frames[index - 1]
    relativePoint = "TOPRIGHT"
    offsetX = BUFF_SPACING
    offsetY = 0
  end
  frame:SetPoint("TOPLEFT", relativeTo, relativePoint, offsetX, offsetY)

  frames[index] = frame
  return frame
end
